#pragma once
#include "stdafx.h"

// Used for CRC calculation
#define POLY 0x8408

// A static class providing various fonctions to p_format ISO-TP data.
class CPCanIsoTpUtils
{
	public:
		const static int ISOTP_MSG_PHYS_MAX_LENGTH = 4095; // Maximum data length of a physical ISO-TP message.
		const static int ISOTP_MSG_FUNC_MAX_LENGTH = 7; // Maximum data length of a functional ISO-TP message.
		enum TPCANDevice : byte {}; // Represents a PCAN device

		static CString GetVarName(char * p_name);
		static CString GetCStringValue(int p_int, std::vector<std::tuple<WORD, CString>> p_vector);
		static CString GetBitrate(TPCANTPBaudrate p_value);
		static CString GetChannelName(TPCANTPHandle p_handle);
		static CString GetParameter(TPCANTPParameter p_param);
		static CString GetError(TPCANTPStatus p_error);
		static CString GetFormatType(TPCANTPFormatType p_format);
		static CString GetTimeString(TPCANTPTimestamp p_ts, bool p_showPeriod, TPCANTPTimestamp p_tsOld);
		static CString GetDataString(TPCANTPMsg p_msg);
		static CString GetUniqueID(TPCANTPMsg p_msg);
		static CString GetCanIdType(TPCANTPIdType p_type);
		static CString GetTargetType(TPCANTPAddressingType p_type);
		static CString GetMsgType(TPCANTPMessageType p_type);
		static CString GetAddress(byte p_address);
		static CString GetCanId(UINT32 p_canId, bool p_isExtended);
		static CString GetResult(TPCANTPConfirmation p_result);
		static DWORD GetDWordValue(CString p_int, std::vector<std::tuple<WORD, CString>> p_vector);
		static DWORD GetBitrate_DWORD(CString p_value);
		static DWORD GetParameter_DWORD(CString p_param);
		static DWORD GetFormatType_DWORD(CString p_format);
		static DWORD GetCanIdType_DWORD(CString p_type);
		static DWORD GetTargetType_DWORD(CString p_type);
		static DWORD GetMsgType_DWORD(CString p_type);
		static DWORD GetCANDefValue(CString p_str);
		static CString IntToHex(int p_iValue, short p_iDigits);
		static CString IntToStr(int p_iValue);
		static DWORD HexTextToInt(CString ToConvert);
		static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, std::initializer_list<int> p_Args = {}, TPCANTPMsg * p_Msg = NULL);
		static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, char* p_Msg, BYTE p_Parameter = 0);
		static void ConvertUnicodeCharToMultibytesChar(CString p_strIn, LPSTR p_strOut);
		static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, MappingStatus* p_Mapping);
		static CString GetCallerMethodName(void);
		static long HexStrToDec(const CString& p_sHex);
		static unsigned short crc16(BYTE *p_data, unsigned short p_length);
		static unsigned short crc16(char * p_data, unsigned short p_length);
		static UINT32 GetUniqueID(std::initializer_list<int> p_Args);
};

